<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model 
{

    protected $table = 'payments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status', 'payment_time');

    public function enrollment()
    {
        return $this->hasMany('Enrollment', 'payment_id');
    }

    public function training()
    {
        return $this->belongsTo('Training', 'training_id');
    }

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

}